--[[---------------------------------------------------------------------------
	Chocolatier Two Recipe Book
	Copyright (c) 2006-2007 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

gCurrentFactory = gCurrentFactory or gDialogTable.factory
if gCurrentFactory then
	gRecipeSelection = gCurrentFactory.product
end

gRecipeSelection = gRecipeSelection or LItem:ByName("b_01")

-------------------------------------------------------------------------------

local tabfont = { standardFontName, 13, DefaultColor }

local function TypeTab(t)
	local type = LProductType:ByName(t.name) or LProductType:ByName("square")
	return Button
	{
		x=0,y=t.y, w=64,h=50, fit=true, type=kRadio,
		name="tab_"..t.name,
		command = function()
			gRecipeSelection = type.products[1]
			UpdateDynamicContent("recipe_type")
			UpdateDynamicContent("recipe_recipe")
		end,

		graphics = { "image/factory_recipes_tab_up", "image/factory_recipes_tab_down", "image/factory_recipes_tab_over", "image/factory_recipes_tab_down", },
		SelectLayer(0),
		Bitmap { x=8,y=2, image="image/machine_" .. t.name .. "_small" },
		Text { x=0,y=34,w=50,h=bsgFontHeight(tabfont), label=LabelString(t.name), font=tabfont, },

		SelectLayer(1),
		Bitmap { x=13,y=2, image="image/machine_" .. t.name .. "_small" },
		Text { x=5,y=34,w=50,h=bsgFontHeight(tabfont), label=LabelString(t.name), font=tabfont, },

		SelectLayer(2),
		Bitmap { x=8,y=2, image="image/machine_" .. t.name .. "_small" },
		Text { x=0,y=34,w=50,h=bsgFontHeight(tabfont), label=LabelString(t.name), font=tabfont, },

		SelectLayer(3),
		Bitmap { x=13,y=2, image="image/machine_" .. t.name .. "_small" },
		Text { x=5,y=34,w=50,h=bsgFontHeight(tabfont), label=LabelString(t.name), font=tabfont, },
	}
end


-------------------------------------------------------------------------------

local buttons

if gCurrentFactory then
	buttons =
	{
		TextButton { x=230,y=324-48, name="select_recipe",
			label=LabelString("select_recipe"), font=standardFont,
			command = function() CloseWindow(gRecipeSelection) end, },

--		TextButton { x=50,y=324-48, label="close", command=function() CloseWindow(nil) end, },
		TextButton { x=50,y=324-48, name="help", label="help", graphics=SmallButtonGraphics, command=function() HelpDialog(10) end },
		TextButton { x=50+62,y=324-48, label="close", command=function() CloseWindow(nil) end, graphics=MediumButtonGraphics },
	}
else
	buttons =
	{
--		TextButton { x=120,y=324-45, label="close", command=function() CloseWindow(nil) end, },
		TextButton { x=120,y=324-45, name="help", label="help", graphics=SmallButtonGraphics, command=function() HelpDialog(10) end },
		TextButton { x=120+62,y=324-45, label="close", command=function() CloseWindow(nil) end, graphics=MediumButtonGraphics },
	}
end

-------------------------------------------------------------------------------

local yTop = 20
if gSim.quest then yTop = 0 end

local yTab = 17
local dyTab = 50

MakeDialog
{
	Window
	{
		x=0,y=yTop+ui.yOffset, fit=true,
		
--		TypeTab { x=100,y=0,w=95,h=bsgFontHeight(tabfont), name="infusion", label="infusion" },
--		TypeTab { x=200,y=0,w=95,h=bsgFontHeight(tabfont), name="sauce", label="sauce" },
--		TypeTab { x=300,y=0,w=95,h=bsgFontHeight(tabfont), name="praline", label="praline" },
--		TypeTab { x=400,y=0,w=95,h=bsgFontHeight(tabfont), name="truffle", label="truffle" },
--		TypeTab { x=500,y=0,w=95,h=bsgFontHeight(tabfont), name="exotic", label="exotic" },
		
		Bitmap
		{
			x=0,y=0, image="image/factory_recipes", mask="image/factory_recipes_mask",
			
			DynamicWindow { x=48,y=9,w=ui.rbWidth,h=ui.rbHeight, name="recipe_type", contents="ui/recipebook_type.lua"},
--			DynamicWindow { x=406,y=9,w=ui.rbWidth,h=ui.rbHeight, name="recipe_recipe", contents="ui/recipebook_recipe.lua"},
			DynamicWindow { x=406,y=9,w=ui.rbWidth,h=ui.rbHeight, name="recipe_recipe", contents="ui/recipebook_recipe.lua"},
		},
		
		BeginGroup(),
		TypeTab { y=yTab, name="square" },
		TypeTab { y=yTab + dyTab, name="infusion" },
		TypeTab { y=yTab + 2*dyTab, name="sauce" },
		TypeTab { y=yTab + 3*dyTab, name="praline" },
		TypeTab { y=yTab + 4*dyTab, name="truffle" },
		TypeTab { y=yTab + 5*dyTab, name="exotic" },

		Group(buttons),
	}
}

SetButtonToggleState("tab_"..gRecipeSelection.type.name, true)
